<?php
/**
* copyright 2beweb2.com.
*
* NOTICE OF LICENSE
*
* This source file is subject to Commercial Licence Copyright
* You can modifify this and use only on the site declared when you bought it.
*
*    @author    2beweb2 <ca@2beweb2.com>
*    @copyright 2beweb2 - Plante-i sarl France
*    @license   Coomercial Licence
*    International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Tobewebto_brexit extends TaxManagerModule
{
    protected $config_form = false;

    public function __construct()
    {
        $this->name = 'tobewebto_brexit';
        $this->tab = 'billing_invoicing';
        $this->version = '1.1.0';
        $this->author = '2beweb2';
        $this->need_instance = 1;
        $this->tax_manager_class = 'BrexitTaxManager';
        $this->module_key = '2faccc93b327d0d709910d494539daab';

        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Brexit module allow you to choose rules for selling on UK and EU after Brexit');
        $this->description = $this->l('You can choose to sell only when cart is > 135 pound or apply uk vat if less than this, and selling to company without tva.');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        Configuration::updateValue('TOBEWEBTO_BREXIT_removevateu', true);
        Configuration::updateValue('TOBEWEBTO_BREXIT_sell135p', false);
        Configuration::updateValue('TOBEWEBTO_BREXIT_sell135l', false);
        Configuration::updateValue('TOBEWBETO_BREXIT_COUNTRY', Configuration::get('PS_COUNTRY_DEFAULT'));

        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader') &&
            $this->registerHook('displayFooter') &&
            $this->registerHook('displayHeader') &&
            $this->registerHook('actionCartUpdateQuantityBefore') &&
            $this->registerHook('displayCheckoutSubtotalDetails') &&
            $this->registerHook('actionCartSave') &&
            $this->registerHook('displayPaymentTop') &&
            $this->registerHook('displayShoppingCartFooter');
    }

    public function uninstall()
    {
        Configuration::deleteByName('TOBEWEBTO_BREXIT_removevateu');
        Configuration::deleteByName('TOBEWEBTO_BREXIT_sell135p');
        Configuration::deleteByName('TOBEWEBTO_BREXIT_sell135l');
        Configuration::deleteByName('TOBEWBETO_BREXIT_COUNTRY');

        return parent::uninstall();
    }

    public function enable($force_all = false)
    {
        parent::enable($force_all);
        Configuration::updateValue('TOBEWEBTO_BREXIT_removevateu', 1);
    }

    public function disable($force_all = false)
    {
        parent::disable($force_all);
        Configuration::updateValue('TOBEWEBTO_BREXIT_removevateu', 0);
    }


    public function getContent()
    {
        $alert_GBP = null;
        $total_135l = 0;
        $total_135p = 0;
        
        if (((bool)Tools::isSubmit('submitTobewebto_brexitModule')) == true) {
            $this->postProcess();
        }
        
        if (Configuration::get('TOBEWBETO_BREXIT_FROMDATE') AND  Configuration::get('TOBEWBETO_BREXIT_TODATE'))
        {
            $sqll = "select sum(total_products_wt) from "._DB_PREFIX_."orders o JOIN "._DB_PREFIX_."address a ON o.id_address_delivery = a.id_address JOIN "._DB_PREFIX_."country c ON a.id_country = c.id_country where o.date_add BETWEEN '2020-12-01' AND '2020-12-31' AND o.valid = 1 AND c.iso_code LIKE 'GB' AND total_products = total_products_wt";
            $total_135l = Db::getInstance()->getValue($sqll);

            $sqlp = "select sum(total_products_wt) from "._DB_PREFIX_."orders o JOIN "._DB_PREFIX_."address a ON o.id_address_delivery = a.id_address JOIN "._DB_PREFIX_."country c ON a.id_country = c.id_country where o.date_add BETWEEN '2020-12-01' AND '2020-12-31' AND o.valid = 1 AND c.iso_code LIKE 'GB' AND total_products > total_products_wt";
            $total_135p = Db::getInstance()->getValue($sqlp);

        }
        $this->context->smarty->assign('total_135l', $total_135l);
        $this->context->smarty->assign('total_135p', $total_135p);
        $this->context->smarty->assign('module_dir', $this->_path);
        
        if (!Currency::exists('EUR')) {
            $alert_GBP = $this->l('British Pound is not Installed as currency I cannot calculate the 135 limit!', 'tobewebto_brexit');
            $this->context->smarty->assign('alert_GBP', $alert_GBP);
        }
        

        $output1 = $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
        $output2 = $this->context->smarty->fetch($this->local_path.'views/templates/admin/export.tpl');
        return $output1.$this->renderForm().$output2;
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitTobewebto_brexitModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    protected function getConfigForm()
    {
        $countries = Country::getCountries($this->context->language->id);

        $countries_fmt = array(
            0 => array(
                'id' => 0,
                'name' => $this->l('-- Choose a country --')
            )
        );

        foreach ($countries as $country)
            $countries_fmt[] = array(
                'id' => $country['id_country'],
                'name' => $country['name']
            );
        
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Settings'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Eu Vat customer vat'),
                        'name' => 'TOBEWEBTO_BREXIT_removevateu',
                        'is_bool' => true,
                        'desc' => $this->l('If active company customer on eu will buy without vat'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                    'disabled' => false,
                        'type' => 'switch',
                        'label' => $this->l('UK FORBID sell > 135 British Pound'),
                        'name' => 'TOBEWEBTO_BREXIT_sell135p',
                        'is_bool' => true,
                        'desc' => $this->l('If active customer on UK CANNOT buy > 135 pound without vat'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                    'disabled' => false,
                        'type' => 'switch',
                        'label' => $this->l('UK FORBID sell < 135 British Pound'),
                        'name' => 'TOBEWEBTO_BREXIT_sell135l',
                        'is_bool' => true,
                        'desc' => $this->l('If active customer on UK CANNOT buy < 135 pound with vat'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
					array(
						'type' => 'select',
						'label' => $this->l('Customers\' country'),
						'desc' => $this->l('Filter customers\' country.'),
						'name' => 'TOBEWBETO_BREXIT_COUNTRY',
						'required' => false,
						'default_value' => (int)$this->context->country->id,
						'options' => array(
							'query' => $countries_fmt,
							'id' => 'id',
							'name' => 'name',
						)
					),
                    array(
                    'disabled' => true,
                        'type' => 'date',
                        'label' => $this->l('Export from date:'),
                        'name' => 'TOBEWBETO_BREXIT_FROMDATE',
                        'size' => 10,
                        'required' => true,
                        'desc' => $this->l('Insert dates for export invoice'),
                    ),
                    array(
                    'disabled' => true,
                        'type' => 'date',
                        'label' => $this->l('Export to date:'),
                        'name' => 'TOBEWBETO_BREXIT_TODATE',
                        'size' => 10,
                        'required' => true,
                        'desc' => $this->l('Insert dates for export invoice'),
                    ),

                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    protected function getConfigFormValues()
    {
        return array(
            'TOBEWEBTO_BREXIT_removevateu' => Configuration::get('TOBEWEBTO_BREXIT_removevateu', true),
            'TOBEWEBTO_BREXIT_sell135p' => Configuration::get('TOBEWEBTO_BREXIT_sell135p', true),
            'TOBEWEBTO_BREXIT_sell135l' => Configuration::get('TOBEWEBTO_BREXIT_sell135l', true),
            'TOBEWBETO_BREXIT_COUNTRY' => Configuration::get('TOBEWBETO_BREXIT_COUNTRY', true),
            'TOBEWBETO_BREXIT_FROMDATE' => Configuration::get('TOBEWBETO_BREXIT_FROMDATE', true),
            'TOBEWBETO_BREXIT_TODATE' => Configuration::get('TOBEWBETO_BREXIT_TODATE', true),
            
        );
    }

    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key));
        }
    }

    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path.'views/js/back.js');
            $this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }


    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }

    public function hookDisplayFooter()
    {
        /* Place your code here. */
    }

    public function hookDisplayHeader()
    {
        $cart = $this->context->cart;
        $address = new Address($cart->id_address_delivery);
        $country = new Country($address->id_country);
 
        if ($country->iso_code == "GB")
        {
            $cart_noship = $this->context->cart->getOrderTotal(false, Cart::BOTH_WITHOUT_SHIPPING, null, null, true);
            $currency = Currency::getCurrency($this->context->cart->id_currency);
            
            if ($currency['iso_code']!='GBP') {
                $newcurrency = Currency::getCurrencyInstance(Currency::getIdByIsoCode('GBP',0,false,1));
    
                $cart_noship2 = Tools::convertPrice($cart_noship, $newcurrency);
            }
    
            $this->context->cookie->__set(
                'total_cart_temp',
                $cart_noship
            );
            
            /*
            print 'currency='.$currency['iso_code'];
            print  '-'.Context::getContext()->cookie->__get(
                'total_cart_temp'
            );
            */
        }
    }

    public function hookDisplayShoppingCartFooter()
    {
        /* Place your code here. */
    }
    
 
    public function hookdisplayCheckoutSubtotalDetails()
    {
        $cart = $this->context->cart;
        $address = new Address($cart->id_address_delivery);
        $country = new Country($address->id_country);
 
        if ($country->iso_code == "GB")
        {
            if (Configuration::get('TOBEWEBTO_BREXIT_sell135p') || Configuration::get('TOBEWEBTO_BREXIT_sell135l')) {
                $cartalert = $this->l('Due to Brexit you have warning on GB:', 'tobewebto_brexit');
                if (Configuration::get('TOBEWEBTO_BREXIT_sell135p')) {
                    $cartalert .= ' '.$this->l('Cannot have a cart greater than 135 Pound', 'tobewebto_brexit');
                }
                if (Configuration::get('TOBEWEBTO_BREXIT_sell135l')) {
                    $cartalert .= ' '.$this->l('Cannot have a cart smaller than 135 Pound', 'tobewebto_brexit');
                }
                $this->context->smarty->assign(array('cartalert' => $cartalert));
            return $this->display(__FILE__, 'cartalert.tpl');
            }
        }
    }
    
    public function hookActionCartUpdateQuantityBefore()
    {
        /* Place your code here. */
    }    

    public function hookactionCartSave($params)
    {
        /* Place your code here. */
    }

    public function hookdisplayPaymentTop($params)
    {
        
        $cart = $this->context->cart;
        $address = new Address($cart->id_address_delivery);
        $country = new Country($address->id_country);

        if ($country->iso_code == "GB")
        {
            $block_cart = false;
            $cart_noship = $this->context->cart->getOrderTotal(false, Cart::BOTH_WITHOUT_SHIPPING, null, null, true);
            $currency = Currency::getCurrency($this->context->cart->id_currency);
            
            if ($currency['iso_code']!='GBP') {
                $newcurrency = Currency::getCurrencyInstance($currency['id_currency']);
                $cart_noship = Tools::convertPrice($cart_noship, $newcurrency);
            }

            if (Configuration::get('TOBEWEBTO_BREXIT_sell135p') || Configuration::get('TOBEWEBTO_BREXIT_sell135l')) {
                $cartalert = $this->l('Due to Brexit you have warning on GB:', 'tobewebto_brexit');
                if (Configuration::get('TOBEWEBTO_BREXIT_sell135p') && $cart_noship >= 135) {
                    $cartalert .= ' '.$this->l('Cannot have a cart greater than 135 Pound', 'tobewebto_brexit');
                    $block_cart = true;
                }
                if (Configuration::get('TOBEWEBTO_BREXIT_sell135l' && $cart_noship < 135)) {
                    $cartalert .= ' '.$this->l('Cannot have a cart smaller than 135 Pound', 'tobewebto_brexit');
                    $block_cart = true;
                }
            }
          
            $cart_url = $this->context->link->getPageLink(
                'cart',
                null,
                $this->context->language->id,
                array(
                    'action' => 'show'
                ),
                false,
                null,
                true
            );

              if ($block_cart) {
                  $ssl = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'));
                  $base = $ssl ? 'https:' : 'http:';
                  Tools::redirect($base . $cart_url);
              }
        }
    }

    /* from PrestaShop VatNumber module */
    public static function getPrefixIntracomVAT()
    {
        $intracom_array = array(
            'AT' => 'AT',
            //Austria
            'BE' => 'BE',
            //Belgium
            'DK' => 'DK',
            //Denmark
            'FI' => 'FI',
            //Finland
            'FR' => 'FR',
            //France
            'FX' => 'FR',
            //France métropolitaine
            'DE' => 'DE',
            //Germany
            'GR' => 'EL',
            //Greece
            'IE' => 'IE',
            //Irland
            'IT' => 'IT',
            //Italy
            'LU' => 'LU',
            //Luxembourg
            'NL' => 'NL',
            //Netherlands
            'PT' => 'PT',
            //Portugal
            'ES' => 'ES',
            //Spain
            'SE' => 'SE',
            //Sweden
            'GB' => 'GB',
            //United Kingdom
            'CY' => 'CY',
            //Cyprus
            'EE' => 'EE',
            //Estonia
            'HU' => 'HU',
            //Hungary
            'LV' => 'LV',
            //Latvia
            'LT' => 'LT',
            //Lithuania
            'MT' => 'MT',
            //Malta
            'PL' => 'PL',
            //Poland
            'SK' => 'SK',
            //Slovakia
            'CZ' => 'CZ',
            //Czech Republic
            'SI' => 'SI',
            //Slovenia
            'RO' => 'RO',
            //Romania
            'BG' => 'BG',
            //Bulgaria
            'HR' => 'HR',
            //Croatia
        );

        return $intracom_array;
    }

    public static function isApplicable($id_country)
    {
        return (((int)$id_country && array_key_exists(Country::getIsoById($id_country), self::getPrefixIntracomVAT())) ? 1 : 0);
    }

}
