<?php
/**
* copyright 2beweb2.com.
*
* NOTICE OF LICENSE
*
* This source file is subject to Commercial Licence Copyright
* You can modifify this and use only on the site declared when you bought it.
*
*    @author    2beweb2 <ca@2beweb2.com>
*    @copyright 2beweb2 - Plante-i sarl France
*    @license   Coomercial Licence
*    International Registered Trademark & Property of PrestaShop SA
*/

class BrexitTaxManager implements TaxManagerInterface
{
    public static function isAvailableForThisAddress(Address $address)
    {
        /*
        HOTFIX
        
        For some reason, this check is called 6 times (?)

        1 w. the real address
        2 w.o. the real address

        1 w. the real address
        2 w.o. the real address

        => [1 0 0 1 0 0]

        So we need to filter out the weird calls...

        We do this by caching the correct calls between calls;
        by creating a static variable, which we save the address to,
        if it does not contain NULL in some of the other fields.
        */

        static $cached_address = null;

        if ($address->id_customer != null) {
            $cached_address = $address;
        }

        // Now, check on the cached address object
        if (!empty($cached_address->vat_number)
            && !empty($cached_address->id_country)
            && $cached_address->id_country != Configuration::get('TOBEWBETO_BREXIT_COUNTRY')
            && Configuration::get('TOBEWEBTO_BREXIT_removevateu'))
            {
             $result = true;
                } else {
             $result = false;
                }

        $total_cart = Context::getContext()->cookie->__get('total_cart_temp');
        $countryIso = Country::getIsoById($address->id_country); 

        if ($countryIso == 'GB' 
            && Configuration::get('TOBEWEBTO_BREXIT_removevateu')
            && strtolower(substr($cached_address->postcode,0,2))!='bt'
            && $total_cart > 135) {
		     $result = true; 
            }

        return ($result);
    }

    public function getTaxCalculator()
    {
        // If the address matches the european vat number criterias no taxes are applied
        $tax = new Tax();
        $tax->rate = 0;

        return new TaxCalculator(array($tax));
    }
}
